


#R FUNCTIONS TO OBTAIN THE MARKOV CHAINS ASSOCIATED WITH 
#INTEGRAL PRIORS AND THE R FUNCTION TO COMPUTE THE POSTERIOR
#PROBABILITY OF THE MODEL M2

#LIBRARIES np, mvtnorm and MASS




#Rank of a matrix#

rango<-function(A){return(qr(A)$rank)}



#Bernoulli simulation#

r.Ber<-function(p){return(rbinom(1,1,p))}


###########################################
#HOW MANY TIMES EACH ROW INTO MATRIZ A IS REPEATED ?#
###########################################

repfA<-function(A){

veces<-{};
for(j in 1:nrow(A)){
count<-0
for(i in 1:nrow(A)){
if(all(A[i,]==A[j,])){count<-count+1;}
}
veces<-c(veces,count)
}
return(matrix(veces))
}


######################################
#SIMULATION: r INDEPENDENT ROWS FROM A MATRIX#
######################################

sim.filas.2<-function(r,A){

k<-dim(A)[2];
n<-dim(A)[1];
condicion<-0;

while(condicion==0){
orden<-sample(1:n);
B<-A[orden,];
if(any(B[1,]!=rep(0,k))){condicion<-1};
}

X<-B;
B<-matrix(X[1,],nrow=1);
i<-1;
filas<-orden[1];

rb<-1
while(rb!=r){
if(rango(rbind(B,X[i+1,]))==1+rb){B<-rbind(B,X[i+1,]);rb<-rb+1;filas<-c(filas,orden[i+1])};
i<-i+1;
}
return(cbind(B,filas));
}



sim.filas.1<-function(k0,A){

k<-dim(A)[2]
n<-dim(A)[1];
condicion<-0;
r<-k-k0;

while(condicion==0){
orden<-sample(1:n);
B<-A[orden,];
if(any(B[1,(k0+1):k]!=rep(0,r))){condicion<-1};
}

X<-B;
B<-matrix(X[1,],nrow=1);
i<-1;
filas<-orden[1];

rb<-1
while(rb!=r){
if(rango(rbind(B[,(k0+1):k],X[i+1,(k0+1):k]))==1+rb){
B<-rbind(B,X[i+1,]);rb<-rb+1;filas<-c(filas,orden[i+1])}
i<-i+1;
}
return(cbind(B,filas));
}




######################
#SIMULATION. MARKOV CHAIN#
######################

transition<-function(theta2,X,k0,veces1,veces2){

k<-ncol(X);k1<-k-k0;

R1<-sim.filas.1(k0,X);
R1.ult<-R1[,k+1];
R1<-R1[,1:k];
R2<-R1[,(k0+1):k];
count<-veces1[R1.ult];
q<-{};
for(j in 1:length(count)){q<-c(q,sample(1:count[j],1))};
xbeta<-R1%*%theta2;
ptilde<-g.inv(xbeta);
vec<-rbinom(k1,q,ptilde);
ptilde<-rbeta(k1,vec+.5,q-vec+.5);
v<-solve(R2)%*%matrix(g(ptilde),ncol=1);
theta1<-c(rep(0,k0),t(v));
dim(theta1)<-c(k,1);
S<-sim.filas.2(k,X);
S.ult<-S[,k+1];
S<-S[,1:k]
count<-veces2[S.ult];
q<-{};
for(j in 1:length(count)){q<-c(q,sample(1:count[j],1))};
xbeta<-S%*%theta1;
ptilde<-g.inv(xbeta);
vec<-rbinom(k,q,ptilde);
ptilde<-rbeta(k,vec+.5,q-vec+.5);
v<-solve(S)%*%matrix(g(ptilde),ncol=1);
theta2p<-v;
return(cbind(theta1,theta2p));}



#######Probit###########

g<-function(p){return(qnorm(p,0,1))}

g.inv<-function(bx){
return(pnorm(bx,0,1));
}


####Complementary log-log####

g<-function(p){return(log(-log(1-p)))}

g.inv<-function(bx){return(1-exp(-exp(bx)))}


####LOGISTIC LINK FUNCTION###

g<-function(p){return(log(p/(1-p)));}

g.inv<-function(bx){
return(exp(bx)/(1+exp(bx)));
}





######################################################
#######R FUNCTION TO COMPUTE THE INTEGRAL BAYES FACTOR########
######################################################


postProbM2<-function(res1,res2,tabla1,tabla2,desde,hasta,y.sample,simul)
{

lugar<-1:ncol(res2$x);
lugar<-c(desde:hasta,lugar[-(desde:hasta)]);
long.cadena<-ncol(tabla1);

formula1<-as.formula(paste("~",paste(paste("x",1:ncol(res1$x),sep=""),collapse="+")));
formula2<-as.formula(paste("~",paste(paste("x",1:ncol(res2$x),sep=""),collapse="+")));

t2<-data.frame(t(tabla2),row.names=1:long.cadena);
names(t2)<-paste("x",1:ncol(res2$x),sep="");
bw <- npudensbw(formula2,data=t2,bwmethod="normal-reference");

V<-summary(res2)$cov.scaled;
V<-V[,lugar];
V<-V[lugar,];
theta<-res2$coef;
theta<-matrix(theta,nrow=1);
theta<-theta[lugar];

datoseval<-mvrnorm(simul,mu=theta,Sigma=2*V);
names(datoseval)<-names(t2);
fhat <- npudens(bws=bw,edat=datoseval);

points<-cbind(fhat$eval,fhat$dens);
points<-cbind(points,dmvnorm(points[,1:ncol(V)],mean=theta,sigma=2*V));
w<-points[,ncol(points)-1]/points[,ncol(points)];

tabla<-t(points[,1:ncol(V)]);
p<-g.inv((X%*%tabla));
l<-(p^y.sample)*((1-p)^(1-y.sample));
m2<-exp(colSums(log(l)));
m2<-m2*w;

m2<-mean(m2);

t1<-data.frame(t(tabla1),row.names=1:long.cadena);
t1<-t1[,(k0+1):ncol(t1)];
names(t1)<-paste("x",1:ncol(res1$x),sep="");
bw <- npudensbw(formula1,data=t1,bwmethod="normal-reference");

V<-summary(res1)$cov.scaled;
theta<-res1$coef;
theta<-matrix(theta,nrow=1);

datoseval<-mvrnorm(simul,mu=theta,Sigma=2*V);
names(datoseval)<-names(t1);
fhat <- npudens(bws=bw,edat=datoseval);

points<-cbind(fhat$eval,fhat$dens);
points<-cbind(points,dmvnorm(points[,1:ncol(V)],mean=theta,sigma=2*V));
w<-points[,ncol(points)-1]/points[,ncol(points)];

tabla<-t(points[,1:ncol(V)]);
tabla<-rbind(matrix(0,nrow=k0,ncol=simul),tabla);
p<-g.inv((X%*%tabla));
l<-(p^y.sample)*((1-p)^(1-y.sample));
m1<-exp(colSums(log(l)));
m1<-m1*w;
m1<-mean(m1);

return(m2/(m1+m2));
}






