﻿# Módulos que hay que imortar

import pygame
from pygame.locals import *
import os
import sys
# y cualquier otro modulo usado

# ----------------------------------------------
# Constantes, como anchos y largo de pantalla, etc.
# ----------------------------------------------

SCREEN_WIDTH  = 640
SCREEN_HEIGHT = 480
IMG_DIR       = "imagenes"

# ----------------------------------------------
# Clases y Funciones utilizadas 
# ----------------------------------------------

def load_image(nombre, dir_imagen, alpha=False):
	# Encontramos la ruta completa de la imagen
	ruta = os.path.join(dir_imagen, nombre)
	try:
		image = pygame.image.load(ruta)
	except:
		print("Error, no se puede cargar la imagen: ", ruta)
		sys.exit(1)
	# Comprobar si la imagen tiene "canal_alpha" (como los png)
	if alpha == True:
		image = image.convert_alpha()
	else:
		image = image.convert()
	return image
	
# - - - - - - - - - - - - - 
# Creamos los sprites (clases de los objetos del juego
# - - - - - - - - - - - - - 

class Pelota(pygame.sprite.Sprite):
	"La bola y su comportamiento en la pantalla"
	
	def __init__(self):
		pygame.sprite.Sprite.__init__(self)
		self.image = load_image("bola.png", IMG_DIR, alpha=True)
		self.rect = self.image.get_rect()
		self.rect.centerx = SCREEN_WIDTH / 2
		self.rect.centery = SCREEN_HEIGHT / 2
		self.speed = [3,3]
		
	def update(self):
		if self.rect.left < 0 or self.rect.right > SCREEN_WIDTH:
			self.speed[0] = -self.speed[0]
		if self.rect.top <0 or self.rect.bottom  > SCREEN_HEIGHT:
			self.speed[1] = -self.speed[1]
		self.rect.move_ip((self.speed[0], self.speed[1]))
		
	def colision(self, objetivo):
		if self.rect.colliderect(objetivo.rect):
			self.speed[0] = -self.speed[0]

class Paleta(pygame.sprite.Sprite):
	"Define el comportamiento d elas paletas de ambos jugadores"
	
	def __init__(self, x):
		pygame.sprite.Sprite.__init__(self)
		self.image = load_image("paleta.png", IMG_DIR, alpha=True)
		self.rect = self.image.get_rect()
		self.rect.centerx = x
		self.rect.centery = SCREEN_HEIGHT / 2
		
	def humano(self):
		#Controlar que la paleta no salga de la pantalla
		if self.rect.bottom >= SCREEN_HEIGHT:
			self.rect.bottom = SCREEN_HEIGHT
		elif self.rect.top <= 0:
			self.rect.top = 0
			
	def cpu(self, objetivo):
		self.rect.centery = objetivo.rect.centery
		if self.rect.bottom >= SCREEN_HEIGHT:
			self.rect.bottom = SCREEN_HEIGHT
		elif self.rect.top <=0:
			self.rect.top = 0
		
# - - - - - - - - - - - - - 
# Función principal del juego
# - - - - - - - - - - - - - -

def main():
    pygame.init()
	# Creamos la ventana y le indicamos un título
    screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
    pygame.display.set_caption("Mi primer juego: Pong")

    # Cargamos el fondo
    fondo = load_image("fondo_pong.jpg", IMG_DIR, alpha=False)
    bola  = Pelota()
    jugador1 = Paleta(25)
    jugador2 = Paleta(SCREEN_WIDTH - 25)

    clock = pygame.time.Clock()
    pygame.key.set_repeat(1, 25) # activa repetición de teclas
    pygame.mouse.set_visible(False)
	
    # el bucle principal del juego
    while True:
        clock.tick(60)

        # Actualizamos los objetos en pantalla
        jugador1.humano()
        jugador2.cpu(bola)
        bola.update()

        # Comprobamos si colisionan los objetos
        bola.colision(jugador1)
        bola.colision(jugador2)
        
        # Posibles entradas del teclado y ratón
        for event in pygame.event.get():
                if event.type == pygame.QUIT:
                        sys.exit(0)
                elif event.type == pygame.KEYDOWN:
                        if event.key == K_UP:
                                jugador1.rect.centery -= 5
                        elif event.key == K_DOWN:
                                jugador1.rect.centery += 5
                        elif event.key == K_ESCAPE:
                                sys.exit(0)
				
	# Actualizamos la pantalla
        screen.blit(fondo, (0,0))
        screen.blit(bola.image, bola.rect)
        screen.blit(jugador1.image, jugador1.rect)
        screen.blit(jugador2.image, jugador2.rect)
        pygame.display.flip()
                
if __name__ == "__main__":
    main()
