﻿# Módulos que hay que imortar

import pygame
from pygame.locals import *
import os
import sys
# y cualquier otro modulo usado

# ----------------------------------------------
# Constantes, como anchos y largo de pantalla, etc.
# ----------------------------------------------

SCREEN_WIDTH  = 640
SCREEN_HEIGHT = 480
IMG_DIR       = "imagenes"
SONIDO_DIR    = "sonidos"

# ----------------------------------------------
# Clases y Funciones utilizadas 
# ----------------------------------------------

def load_image(nombre, dir_imagen, alpha=False):
	# Encontramos la ruta completa de la imagen
	ruta = os.path.join(dir_imagen, nombre)
	try:
		image = pygame.image.load(ruta)
	except:
		print("Error, no se puede cargar la imagen: ", ruta)
		sys.exit(1)
	# Comprobar si la imagen tiene "canal_alpha" (como los png)
	if alpha == True:
		image = image.convert_alpha()
	else:
		image = image.convert()
	return image
	
def load_sonido(nombre, dir_sonido):
	ruta = os.path.join(dir_sonido, nombre)
	# Intenta cargar el sonido
	try:
		sonido = pygame.mixer.Sound(ruta)
	except pygame.error:
		print ("No se pudo cargar el sonido: ", ruta)
		sonido = None
	return sonido
	
# - - - - - - - - - - - - - 
# Creamos los sprites (clases de los objetos del juego
# - - - - - - - - - - - - - 

class Pelota(pygame.sprite.Sprite):
	"La bola y su comportamiento en la pantalla"
	
	def __init__(self, sonido_golpe, sonido_punto):
		pygame.sprite.Sprite.__init__(self)
		self.marcador = [0,0]
		self.image = load_image("bola.png", IMG_DIR, alpha=True)
		self.rect = self.image.get_rect()
		self.rect.centerx = SCREEN_WIDTH / 2
		self.rect.centery = SCREEN_HEIGHT / 2
		self.speed = [3,3]
		self.sonido_golpe = sonido_golpe
		self.sonido_punto = sonido_punto
		
	def update(self):
		if self.rect.left < 0 or self.rect.right > SCREEN_WIDTH:
			if self.rect.left < 0:
				self.marcador[1] += 1
			else: self.marcador[0] +=1

			self.speed[0] = -self.speed[0]
			self.sonido_punto.play()   # Reproducir sonido de punto
			self.rect.centerx = SCREEN_WIDTH / 2   # Reiniciamos la posición de la pelota
			self.rect.centery = SCREEN_HEIGHT / 2
		if self.rect.top <0 or self.rect.bottom  > SCREEN_HEIGHT:
			self.speed[1] = -self.speed[1]
		self.rect.move_ip((self.speed[0], self.speed[1]))
		
	def colision(self, objetivo):
		if self.rect.colliderect(objetivo.rect):
			self.speed[0] = -self.speed[0]
			self.sonido_golpe.play() # Reproducir sonido de rebote

class Paleta(pygame.sprite.Sprite):
	"Define el comportamiento d elas paletas de ambos jugadores"
	
	def __init__(self, x):
		pygame.sprite.Sprite.__init__(self)
		self.image = load_image("paleta.png", IMG_DIR, alpha=True)
		self.rect = self.image.get_rect()
		self.rect.centerx = x
		self.rect.centery = SCREEN_HEIGHT / 2
		
	def humano(self):
		#Controlar que la paleta no salga de la pantalla
		if self.rect.bottom >= SCREEN_HEIGHT:
			self.rect.bottom = SCREEN_HEIGHT
		elif self.rect.top <= 0:
			self.rect.top = 0
			
	def cpu(self, pelota):
		self.speed = [0, 2.5]
		if pelota.speed[0] >= 0 and pelota.rect.centerx >= SCREEN_WIDTH / 2:
			if self.rect.centery > pelota.rect.centery:
				self.rect.centery -= self.speed[1]
			if self.rect.centery < pelota.rect.centery:
				self.rect.centery += self.speed[1]
				
		
# - - - - - - - - - - - - - 
# Función principal del juego
# - - - - - - - - - - - - - -

def main():
    pygame.init()
    pygame.mixer.init()
    MAX_PUNTUACION = 10

    # Creamos la ventana y le indicamos un título
    screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
    pygame.display.set_caption("Mi primer juego: Pong")

    fuente = pygame.font.Font(None, 40)

    # Cargamos el fondo
    fondo = load_image("fondo_pong.jpg", IMG_DIR, alpha=False)
    sonido_golpe = load_sonido("tenis.ogg", SONIDO_DIR)
    sonido_punto = load_sonido("aplausos.ogg", SONIDO_DIR)
	
    bola  = Pelota(sonido_golpe, sonido_punto)
    jugador1 = Paleta(25)
    jugador2 = Paleta(SCREEN_WIDTH - 25)   

    clock = pygame.time.Clock()
    pygame.key.set_repeat(1, 25) # activa repetición de teclas
    pygame.mouse.set_visible(False)

    salir = False
    
    # el bucle principal del juego
    while (bola.marcador[0]<MAX_PUNTUACION and bola.marcador[1] <MAX_PUNTUACION) and salir == False:
        clock.tick(60)

        # Actualizamos los objetos en pantalla
        jugador1.humano()
        jugador2.cpu(bola)
        bola.update()

        # Comprobamos si colisionan los objetos
        bola.colision(jugador1)
        bola.colision(jugador2)
        
        # Posibles entradas del teclado y ratón
        for event in pygame.event.get():
                if event.type == pygame.QUIT:
                        salir = True
                elif event.type == pygame.KEYDOWN:
                        if event.key == K_UP:
                                jugador1.rect.centery -= 5
                        elif event.key == K_DOWN:
                                jugador1.rect.centery += 5
                        elif event.key == K_ESCAPE:
                                salir = True
				
	# Actualizamos la pantalla
        screen.blit(fondo, (0,0))
        todos = pygame.sprite.RenderPlain(bola, jugador1, jugador2)
        todos.draw(screen)
        texto_marcador = " %2d " %(bola.marcador[0])
        mensaje = fuente.render(texto_marcador, 1, (255,255,255))
        texto_marcador = " %2d " %(bola.marcador[1])
        screen.blit(mensaje, (15, 5))
        mensaje = fuente.render(texto_marcador, 1, (255,255,255))
        screen.blit(mensaje, (SCREEN_WIDTH-50,5))

        pygame.display.flip()

    if bola.marcador[0] > bola.marcador[1]:
        texto_ganar = " HAS GANADO "
    elif bola.marcador[0] == bola.marcador[1]:
            texto_ganar = "EMPATE"
    else: texto_ganar = " HAS PERDIDO"
    mensaje = fuente.render(texto_ganar, 1, (255, 0, 0))
    screen.blit(mensaje, ((SCREEN_WIDTH/2)-100, SCREEN_HEIGHT/2))
    pygame.display.flip()
                
if __name__ == "__main__":
    main()
