﻿# Módulos que hay que imortar

import pygame
from pygame.locals import *
import os
import sys
# y cualquier otro modulo usado

# ----------------------------------------------
# Constantes, como anchos y largo de pantalla, etc.
# ----------------------------------------------

SCREEN_WIDTH  = 640
SCREEN_HEIGHT = 480
IMG_DIR       = "imagenes"

# ----------------------------------------------
# Clases y Funciones utilizadas 
# ----------------------------------------------

def load_image(nombre, dir_imagen, alpha=False):
	# Encontramos la ruta completa de la imagen
	ruta = os.path.join(dir_imagen, nombre)
	try:
		image = pygame.image.load(ruta)
	except:
		print("Error, no se puede cargar la imagen: ", ruta)
		sys.exit(1)
	# Comprobar si la imagen tiene "canal_alpha" (como los png)
	if alpha == True:
		image = image.convert_alpha()
	else:
		image = image.convert()
	return image
	
# - - - - - - - - - - - - - 
# Función principal del juego
# - - - - - - - - - - - - - -

def main():
    pygame.init()
	# Creamos la ventana y le indicamos un título
    screen = pygame.display.set_mode((SCREEN_WIDTH, SCREEN_HEIGHT))
    pygame.display.set_caption("Mi primer juego: Pong")

    # Cargamos el fondo
    fondo = load_image("fondo_pong.jpg", IMG_DIR, alpha=False)
	
    # el bucle principal del juego
    while True:
        # Actualizamos la pantalla
        screen.blit(fondo, (0,0))
        pygame.display.flip()
		
        # Posibles entradas del teclado y ratón
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                sys.exit()
                
if __name__ == "__main__":
    main()
